import { FormElement } from '@/Components'
import { ID } from '@/types/models'
import { Lecture } from '@/types/models/lecture'
import { Select } from 'antd'
import React from 'react'

type Props = {
    lectures: Lecture[]
    selected?: ID
    onSelect: (s: ID) => void
}

const LectureSelect = ({ lectures, selected, onSelect }: Props) => {
    return (
        <FormElement label='الدرس' >
            <Select className='w-full' onSelect={onSelect} value={selected}>
                {lectures.map(m => <Select.Option value={m.id} key={m.id} > {m.title} </Select.Option>)}
            </Select>
        </FormElement>
    )
}

export default LectureSelect
