import { FormElement } from '@/Components'
import { ID } from '@/types/models'
import { Level } from '@/types/models/level'
import { Select } from 'antd'
import React from 'react'

type Props = {
    levels: Level[]
    selected?: ID
    onSelect: (s: ID) => void
}

const LevelSelect = ({ levels=[], selected, onSelect }: Props) => {
    return (
        <FormElement label='الصف' >
            <Select className='w-full h-[40px] '  onSelect={onSelect} value={selected}>
                {levels.map(m => <Select.Option value={m.id} key={m.id} > {m.title} </Select.Option>)}
            </Select>
        </FormElement>
    )
}

export default LevelSelect
