import { FormCheckbox, FormElement, FormUpload, ImageOrUpload, PrimaryButton } from '@/Components'
import { APP_URL } from '@/Constants'
import { useFormProps } from '@/types/app'
import { Video } from '@/types/models/video'
import { ensureHttpsUrl } from '@/Utils'
import React, { FormEventHandler, useState } from 'react'
import { ButtonDelete, ButtonEdit } from '..'

type Props = {
    submit: FormEventHandler<HTMLFormElement>
    form: useFormProps<Video>
}

const VideoForm = ({ form, submit }: Props) => {

    const [uploaded, setUploaded] = useState<string | undefined>(form.data.file)

    return (
        <form className='flex flex-col gap-4' onSubmit={submit} >
            <FormElement label='ملف الفيديو'>
                {uploaded ?
                    <div className='flex flex-col gap-3'>
                        <video className='border rounded-md' src={ensureHttpsUrl(uploaded, APP_URL)}></video>
                        <ButtonDelete className='mt-2' onClick={() => setUploaded(undefined)} />
                    </div> :
                    <FormUpload type='video' onSuccess={res => {
                        form.setData('file', res.file_path)
                        setUploaded(res.file_path)
                    }} />}
            </FormElement>
            <FormElement label='ملف الترجمة'>
                <FormUpload type='document' onSuccess={res => form.setData('subtitle_file', res.file_path)} />
            </FormElement>
            <FormCheckbox label='نشط' name='is_active' checked={form.data.is_active} onChange={e => form.setData('is_active', e.target.checked)} error={form.errors.is_active} />
            <PrimaryButton className='mt-4' type="submit">حفظ</PrimaryButton>
        </form>
    )
}

export default VideoForm
